VERSION 5.00
Begin VB.Form frmOfferPrint 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "#Print Offer"
   ClientHeight    =   2835
   ClientLeft      =   45
   ClientTop       =   375
   ClientWidth     =   5580
   ControlBox      =   0   'False
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2835
   ScaleWidth      =   5580
   StartUpPosition =   3  'Windows Default
   Tag             =   "frmOfferPrint"
   Visible         =   0   'False
   Begin VB.Frame fra_MainAlt 
      Height          =   2010
      Left            =   0
      TabIndex        =   2
      Tag             =   "fra_MainAlt"
      Top             =   0
      Width           =   5532
      Begin VB.CheckBox chk_PrintASItemMessage 
         Caption         =   "#Print AS Item Message"
         Height          =   285
         Left            =   210
         TabIndex        =   9
         Tag             =   "chk_PrintASItemMessage"
         Top             =   240
         Width           =   4770
      End
      Begin VB.CheckBox chk_PrintGeneralTerms 
         Caption         =   "#Print General Terms && Conditions"
         Height          =   285
         Left            =   210
         TabIndex        =   8
         Tag             =   "chk_PrintReps"
         Top             =   1575
         Value           =   1  'Checked
         Width           =   4770
      End
      Begin VB.CheckBox chk_PrintReps 
         Caption         =   "#Add Armstrong Reps contact detail in header"
         Height          =   285
         Left            =   210
         TabIndex        =   7
         Tag             =   "chk_PrintReps"
         Top             =   1245
         Value           =   1  'Checked
         Width           =   4770
      End
      Begin VB.CheckBox chk_PrintTotal 
         Caption         =   "#Print Total"
         Height          =   285
         Left            =   210
         TabIndex        =   6
         Tag             =   "chk_PrintTotal"
         Top             =   915
         Width           =   4770
      End
      Begin VB.CheckBox chk_PrintPictures 
         Caption         =   "#Print pictures"
         Height          =   285
         Left            =   210
         TabIndex        =   5
         Tag             =   "chk_PrintPictures"
         Top             =   585
         Width           =   4770
      End
      Begin VB.OptionButton opt_QuotePrintType 
         Caption         =   "#Quote with per SQM prices"
         Height          =   285
         Index           =   0
         Left            =   4410
         TabIndex        =   4
         Tag             =   "opt_PrintMainPrice"
         Top             =   1170
         Visible         =   0   'False
         Width           =   990
      End
      Begin VB.OptionButton opt_QuotePrintType 
         Caption         =   "#Quote with itemized prices"
         Height          =   285
         Index           =   1
         Left            =   4425
         TabIndex        =   3
         Tag             =   "opt_PrintAllPrice"
         Top             =   1440
         Visible         =   0   'False
         Width           =   1035
      End
   End
   Begin VB.CommandButton btn_Validate 
      Height          =   612
      Left            =   4050
      Style           =   1  'Graphical
      TabIndex        =   1
      Tag             =   "btn_Validate"
      Top             =   2100
      Width           =   612
   End
   Begin VB.CommandButton btn_Quit 
      Height          =   612
      Left            =   4860
      Style           =   1  'Graphical
      TabIndex        =   0
      Tag             =   "btn_Quit"
      Top             =   2100
      Width           =   612
   End
End
Attribute VB_Name = "frmOfferPrint"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F

Private Const C_ERRORRAISE As Long = 2500
Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SCREEN_NAME As String = "frmOfferPrint"

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Public Result As Boolean
Private mb_InternalInit As Boolean


#If LIVE = 1 Then
  Private mo_Db As Object
  Private mo_FSO As Object
#Else
  Private mo_Db As ARMSYSCOMLib.ArmDb
  Private mo_FSO As FileSystemObject
#End If

Private ms_UID As String
Private ml_U_Code As Long
Private ms_COF_Id As String
Private mb_ItemizedPrice As Boolean
Private ms_Language_Code As String
Private mc_ScreenLabels As Long
Private mo_Tools As DPC_Tools

Public Property Let U_Code(ByVal al_U_Code As Long)
    ml_U_Code = al_U_Code
End Property

Public Property Let COF_Id(ByVal as_COF_Id As String)
    ms_COF_Id = as_COF_Id
End Property

Property Let Language_Code(AString As String)
  ms_Language_Code = AString
End Property

Property Get Language_Code() As String
  Language_Code = ms_Language_Code
End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
  If Not (lo_Db Is Nothing) Then
      Set mo_Db = lo_Db
  End If
End Property

Public Property Get PrintASItemMessage() As Boolean
On Error GoTo ErrorHandler
  
  PrintASItemMessage = (chk_PrintASItemMessage.Value = vbChecked)
  Exit Property
ErrorHandler:
  Call ErrorHandler("PrintASItemMessage.Get")
End Property

Public Property Get PrintPictures() As Boolean
On Error GoTo ErrorHandler
  
  PrintPictures = (chk_PrintPictures.Value = vbChecked)
  Exit Property
ErrorHandler:
  Call ErrorHandler("PrintPictures.Get")
End Property

Public Property Get PrintTotal() As Boolean
On Error GoTo ErrorHandler
  
  PrintTotal = (chk_PrintTotal.Value = vbChecked)
  Exit Property
ErrorHandler:
  Call ErrorHandler("PrintTotal.Get")
End Property

Public Property Get PrintReps() As Boolean
On Error GoTo ErrorHandler
  
  PrintReps = (chk_PrintReps.Value = vbChecked)
  Exit Property
ErrorHandler:
  Call ErrorHandler("PrintReps.Get")
End Property

Public Property Get PrintGeneralTerms() As Boolean
On Error GoTo ErrorHandler
  
  PrintGeneralTerms = (chk_PrintGeneralTerms.Value = vbChecked)
  Exit Property
ErrorHandler:
  Call ErrorHandler("PrintGeneralTerms.Get")
End Property

Public Sub Load_A_COM()
On Error GoTo ErrHandler

Dim ls_Request As String

  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  
  Call mo_Tools.Load_A_ComControls(Me.Controls, mo_Db, ms_Language_Code)
  
  btn_Validate.Picture = LoadResPicture(RES_OK, 1)
  btn_Quit.Picture = LoadResPicture(RES_QUIT, 1)
  
  Set mo_FSO = New FileSystemObject
  
  ls_Request = "exec Cap_Offer_sel $COF_Id$, $Language_Code$"
  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SqlStrKey(ms_COF_Id), , , vbTextCompare)
  ls_Request = ReplaceCommonPlaceholders(ls_Request)
  mb_ItemizedPrice = StrComp(mo_Tools.SelectValue(mo_Db, ls_Request, "COF_AllPr"), "X", vbTextCompare) = 0
  If mb_ItemizedPrice Then
    opt_QuotePrintType(1).Value = True
  Else
    opt_QuotePrintType(0).Value = True
  End If
  
  'Screen csts
  mc_ScreenLabels = mo_Tools.LoadLabels(mo_Db, Me.Controls, Me, SCREEN_NAME, ms_Language_Code)
  Call mo_Tools.ChangeCharset(Me.Controls, gl_CodePage, gl_CodePage, Me)
  Result = False
  Exit Sub
ErrHandler:
  Call ErrorHandler("Load_A_COM")
End Sub

Public Sub Unload_A_COM()
On Error GoTo ErrHandler

  Call mo_Tools.Unload_A_ComControls(Me.Controls)
  Call mo_Db.Close(mc_ScreenLabels)
  Set mo_Db = Nothing
  Set mo_FSO = Nothing
  Exit Sub
ErrHandler:
  Call ErrorHandler("Unload_A_COM")
End Sub

Private Sub btn_Validate_Click()
On Error GoTo ErrHandler

Dim ls_Request As String
'Dim lb_CurrentItemizedPrice As Boolean

  Call mo_Tools.LockScreen(Me, True)
  'lb_CurrentItemizedPrice = opt_QuotePrintType(1).Value
  
  ' save current price
  'If lb_CurrentItemizedPrice <> mb_ItemizedPrice Then
  '  ls_Request = "UPDATE Cap_Offer SET COF_AllPr=$COF_AllPr$ WHERE COF_Id=$COF_Id$"
  '  ls_Request = Replace(ls_Request, "$COF_Id$", mo_Tools.SQLStr(ms_COF_Id), , , vbTextCompare)
  '  ls_Request = Replace(ls_Request, "$COF_AllPr$", mo_Tools.SqlBool(lb_CurrentItemizedPrice), , , vbTextCompare)
  '  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_Request)
  'End If
  Result = True
  Call mo_Tools.LockScreen(Me, False)
  Hide
  Exit Sub
ErrHandler:
  Call ErrorMessage("btn_Validate_Click")
End Sub

Private Sub btn_Quit_Click()
On Error GoTo ErrHandler
  
  Result = False
  Hide
  Exit Sub
ErrHandler:
  Call ErrorMessage("btn_Quit_Click")
End Sub

Private Function ReplaceCommonPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler

    as_Request = Replace(as_Request, "$Z_Creator$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
    as_Request = Replace(as_Request, "$U_Code$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
    as_Request = Replace(as_Request, "$Z_Last_Upd_User$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
    as_Request = Replace(as_Request, "$Language_Code$", mo_Tools.SQLStr(ms_Language_Code), , , vbTextCompare)
    ReplaceCommonPlaceholders = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplaceCommonPlaceholders")
End Function


' display standard error message
Public Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    Dim ls_Message As String
    
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    ls_Message = SCREEN_NAME & " exception. Nr:" & Err.Number & ",Desc: " & ls_errDescription & ",Src:" & ls_ErrSource & "@"
    Call mo_Tools.LogMessage(mo_Db, ml_U_Code, SCREEN_NAME, ls_Message, "E")
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, Me.Name & "." & as_Fct & SEP1 & Err.Source, Err.Description)
End Sub



